#include "SettingsDialog.h"
#include "mainwindow.h"

IMPLEMENT_CLASS( SettingsDialogClass, wxDialog )

BEGIN_EVENT_TABLE( SettingsDialogClass, wxDialog )
    EVT_BUTTON( wxID_APPLY, SettingsDialogClass::OnApplyButton)
END_EVENT_TABLE()

SettingsDialogClass::SettingsDialogClass(const SettingsClass &Data, wxWindow* parent, wxWindowID id, const wxString& caption,
                                         const wxPoint& pos, const wxSize& size, long style)
{
	SettingsData = Data;
    wxDialog::Create( parent, id, caption, pos, size, style );
    CreateControls();
    SetFocus();
    GetSizer()->Fit(this);
    GetSizer()->SetSizeHints(this);
    SetMaxSize(wxSize(wxDefaultCoord, GetMinSize().y));
    Centre();
}

void SettingsDialogClass::CreateControls()
{
    wxBoxSizer *item0 = new wxBoxSizer( wxVERTICAL );
    this->SetSizer( item0 );

    wxStaticBox *item2 = new wxStaticBox( this, -1, wxT("&Selected dictionary") );
    wxStaticBoxSizer *item1 = new wxStaticBoxSizer( item2, wxVERTICAL );

    wxFilePickerCtrl *item3 = new wxFilePickerCtrl( this, ID_FILEPICKER, wxString(), wxT("Choose file"), wxT("*.dat"), wxDefaultPosition, wxButton::GetDefaultSize(), wxFLP_USE_TEXTCTRL|wxFLP_FILE_MUST_EXIST );
    item1->Add( item3, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    item0->Add( item1, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxFlexGridSizer *item4 = new wxFlexGridSizer( 2, 0, 10 );

    wxStaticBox *item6 = new wxStaticBox( this, -1, wxT("Show &method") );
    wxStaticBoxSizer *item5 = new wxStaticBoxSizer( item6, wxVERTICAL );

    wxRadioButton *item7 = new wxRadioButton( this, ID_RADIOBUTTON_4, wxT("Term / Term + Translation"), wxDefaultPosition, wxDefaultSize, wxRB_GROUP );
    item5->Add( item7, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxRadioButton *item8 = new wxRadioButton( this, ID_RADIOBUTTON_6, wxT("Translation / Term + Translation"), wxDefaultPosition, wxDefaultSize, 0 );
    item5->Add( item8, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxRadioButton *item9 = new wxRadioButton( this, ID_RADIOBUTTON_3, wxT("Term / Translation"), wxDefaultPosition, wxDefaultSize, 0 );
    item5->Add( item9, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxRadioButton *item10 = new wxRadioButton( this, ID_RADIOBUTTON_5, wxT("Translation / Term"), wxDefaultPosition, wxDefaultSize, 0 );
    item5->Add( item10, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxRadioButton *item11 = new wxRadioButton( this, ID_RADIOBUTTON_0, wxT("Term + Translation"), wxDefaultPosition, wxDefaultSize, 0 );
    item5->Add( item11, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxRadioButton *item12 = new wxRadioButton( this, ID_RADIOBUTTON_1, wxT("Only Term"), wxDefaultPosition, wxDefaultSize, 0 );
    item5->Add( item12, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxRadioButton *item13 = new wxRadioButton( this, ID_RADIOBUTTON_2, wxT("Only Translation"), wxDefaultPosition, wxDefaultSize, 0 );
    item5->Add( item13, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    item4->Add( item5, 0, wxGROW|wxALIGN_CENTER_HORIZONTAL, 5 );

    wxStaticBox *item15 = new wxStaticBox( this, -1, wxT("&Fonts and Colors") );
    wxStaticBoxSizer *item14 = new wxStaticBoxSizer( item15, wxVERTICAL );

    wxFlexGridSizer *item16 = new wxFlexGridSizer( 2, 7, 5 );

    wxStaticText *item17 = new wxStaticText( this, ID_TEXT, wxT("Term Font:"), wxDefaultPosition, wxDefaultSize, 0 );
    item16->Add( item17, 0, wxALIGN_CENTER, 5 );

    wxStaticText *item18 = new wxStaticText( this, ID_TEXT, wxT("Translation Font:"), wxDefaultPosition, wxDefaultSize, 0 );
    item16->Add( item18, 0, wxALIGN_CENTER, 5 );

    wxFontPickerCtrl *item19 = new wxFontPickerCtrl( this, ID_TERM_FONTPICKER, wxNullFont, wxDefaultPosition, wxButton::GetDefaultSize(), wxFNTP_FONTDESC_AS_LABEL );
    item16->Add( item19, 0, wxGROW|wxALL, 5 );

    wxFontPickerCtrl *item20 = new wxFontPickerCtrl( this, ID_TRANSLATION_FONTPICKER, wxNullFont, wxDefaultPosition, wxButton::GetDefaultSize(), wxFNTP_FONTDESC_AS_LABEL );
    item16->Add( item20, 0, wxGROW|wxALL, 5 );

    wxStaticText *item21 = new wxStaticText( this, ID_TEXT, wxT("Term Color:"), wxDefaultPosition, wxDefaultSize, 0 );
    item16->Add( item21, 0, wxALIGN_CENTER, 5 );

    wxStaticText *item22 = new wxStaticText( this, ID_TEXT, wxT("Translation Color:"), wxDefaultPosition, wxDefaultSize, 0 );
    item16->Add( item22, 0, wxALIGN_CENTER, 5 );

    wxColourPickerCtrl *item23 = new wxColourPickerCtrl( this, ID_TERM_COLOURPICKER, *wxBLACK, wxDefaultPosition, wxButton::GetDefaultSize(), 0 );
    item16->Add( item23, 0, wxGROW|wxALL, 5 );

    wxColourPickerCtrl *item24 = new wxColourPickerCtrl( this, ID_TRANSLATION_COLOURPICKER, *wxBLACK, wxDefaultPosition, wxButton::GetDefaultSize(), 0 );
    item16->Add( item24, 0, wxGROW|wxALL, 5 );

    wxStaticText *item25 = new wxStaticText( this, ID_TEXT, wxT("Background Color:"), wxDefaultPosition, wxDefaultSize, 0 );
    item16->Add( item25, 0, wxALIGN_CENTER, 5 );

    wxStaticText *item26 = new wxStaticText( this, ID_TEXT, wxT("Border Color:"), wxDefaultPosition, wxDefaultSize, 0 );
    item16->Add( item26, 0, wxALIGN_CENTER, 5 );

    wxColourPickerCtrl *item27 = new wxColourPickerCtrl( this, ID_BACK_COLOURPICKER, *wxBLACK, wxDefaultPosition, wxButton::GetDefaultSize(), 0 );
    item16->Add( item27, 0, wxGROW|wxALL, 5 );

    wxColourPickerCtrl *item28 = new wxColourPickerCtrl( this, ID_BORDER_COLOURPICKER, *wxBLACK, wxDefaultPosition, wxButton::GetDefaultSize(), 0 );
    item16->Add( item28, 0, wxGROW|wxALL, 5 );

    item16->AddGrowableCol( 0 );

    item16->AddGrowableCol( 1 );

    item14->Add( item16, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    item4->Add( item14, 0, wxGROW|wxALIGN_CENTER_HORIZONTAL, 5 );

    item4->AddGrowableCol( 1 );

    item0->Add( item4, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxStaticBox *item30 = new wxStaticBox( this, -1, wxT("Show &time") );
    wxStaticBoxSizer *item29 = new wxStaticBoxSizer( item30, wxVERTICAL );

    wxSlider *item31 = new wxSlider( this, ID_SLIDER_TIMER_INTERVAL, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS );
    item29->Add( item31, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    item0->Add( item29, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxStaticBox *item33 = new wxStaticBox( this, -1, wxT("&Window size") );
    wxStaticBoxSizer *item32 = new wxStaticBoxSizer( item33, wxVERTICAL );

    wxFlexGridSizer *item34 = new wxFlexGridSizer( 2, 0, 15 );

    wxStaticText *item35 = new wxStaticText( this, ID_TEXT, wxT("Horizontal"), wxDefaultPosition, wxDefaultSize, 0 );
    item34->Add( item35, 0, wxGROW|wxALIGN_CENTER_HORIZONTAL, 5 );

    wxStaticText *item36 = new wxStaticText( this, ID_TEXT, wxT("Vertical"), wxDefaultPosition, wxDefaultSize, 0 );
    item34->Add( item36, 0, wxGROW|wxALIGN_CENTER_HORIZONTAL, 5 );

    wxSlider *item37 = new wxSlider( this, ID_SLIDER_WIN_HORIZ, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS );
    item34->Add( item37, 0, wxGROW|wxALIGN_CENTER_HORIZONTAL, 5 );

    wxSlider *item38 = new wxSlider( this, ID_SLIDER_WIN_VERT, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS );
    item34->Add( item38, 0, wxGROW|wxALIGN_CENTER_HORIZONTAL, 5 );

    item34->AddGrowableCol(0);
    item34->AddGrowableCol(1);

    item32->Add( item34, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    item0->Add( item32, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    wxStdDialogButtonSizer *item39 = new wxStdDialogButtonSizer;
    {
        wxButton *button = new wxButton( this, wxID_OK, wxEmptyString, wxDefaultPosition, wxButton::GetDefaultSize() );
        button->SetDefault();
        item39->AddButton( button );
    }
    item39->AddButton( new wxButton( this, wxID_APPLY, wxEmptyString, wxDefaultPosition, wxButton::GetDefaultSize() ) );
    item39->AddButton( new wxButton( this, wxID_CANCEL, wxEmptyString, wxDefaultPosition, wxButton::GetDefaultSize() ) );
    item39->Realize();
    item0->Add( item39, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 10 );
}

bool SettingsDialogClass::TransferDataToWindow()
{
	wxFilePickerCtrl* FilePicker = (wxFilePickerCtrl*)FindWindow(ID_FILEPICKER);
	if (FilePicker != NULL)
	{
		FilePicker->SetPath(SettingsData.FileName);
	}
	wxRadioButton* RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_0 + SettingsData.ShowType);
	if (RadioButton != NULL)
	{
        RadioButton->SetValue(true);
	}

    wxSlider* Slider = (wxSlider*)FindWindow(ID_SLIDER_TIMER_INTERVAL);
    if (Slider != NULL)
    {
    	Slider->SetRange(TimerIntervalMin/1000, TimerIntervalMax/1000);
    	Slider->SetValue(SettingsData.TimerInterval/1000);
    }
    Slider = NULL;

    wxDisplay Display;
    wxRect DisplayRect = Display.GetGeometry();
    Slider = (wxSlider*)FindWindow(ID_SLIDER_WIN_HORIZ);
    if (Slider != NULL)
    {
    	Slider->SetRange(WinMinWidth, DisplayRect.width);
    	Slider->SetValue(SettingsData.Width);
    }
    Slider = NULL;

    Slider = (wxSlider*)FindWindow(ID_SLIDER_WIN_VERT);
    if (Slider != NULL)
    {
    	Slider->SetRange(WinMinHeight, DisplayRect.height);
    	Slider->SetValue(SettingsData.Height);
    }

    wxFontPickerCtrl* FontPicker = (wxFontPickerCtrl*)FindWindow(ID_TERM_FONTPICKER);
    if (FontPicker != NULL)
    {
    	wxFont font;
    	font.SetNativeFontInfoUserDesc(SettingsData.TermFont);
    	FontPicker->SetSelectedFont(font);
    }
    FontPicker = NULL;

    FontPicker = (wxFontPickerCtrl*)FindWindow(ID_TRANSLATION_FONTPICKER);
    if (FontPicker != NULL)
    {
    	wxFont font;
    	font.SetNativeFontInfoUserDesc(SettingsData.TranslationFont);
    	FontPicker->SetSelectedFont(font);
    }

    wxColourPickerCtrl* ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_TERM_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	ColorPicker->SetColour(SettingsData.TermColor);
    }
    ColorPicker = NULL;

    ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_TRANSLATION_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	ColorPicker->SetColour(SettingsData.TranslationColor);
    }
    ColorPicker = NULL;

    ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_BACK_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	ColorPicker->SetColour(SettingsData.BackColor);
    }
    ColorPicker = NULL;

    ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_BORDER_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	ColorPicker->SetColour(SettingsData.BorderColor);
    }

    return true;
}

bool SettingsDialogClass::TransferDataFromWindow()
{
	wxFilePickerCtrl* FilePicker = (wxFilePickerCtrl*)FindWindow(ID_FILEPICKER);
	if (FilePicker != NULL)
	{
		SettingsData.FileName = FilePicker->GetPath();
	}

	wxRadioButton* RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_0);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 0;
	}
	RadioButton = NULL;
	RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_1);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 1;
	}
	RadioButton = NULL;
	RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_2);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 2;
	}
	RadioButton = NULL;
	RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_3);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 3;
	}
	RadioButton = NULL;
	RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_4);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 4;
	}
	RadioButton = NULL;
	RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_5);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 5;
	}
	RadioButton = NULL;
	RadioButton = (wxRadioButton*)FindWindow(ID_RADIOBUTTON_6);
	if (RadioButton != NULL)
	{
		if (RadioButton->GetValue()) SettingsData.ShowType = 6;
	}

    wxSlider* Slider = (wxSlider*)FindWindow(ID_SLIDER_TIMER_INTERVAL);
    if (Slider != NULL)
    {
    	SettingsData.TimerInterval = Slider->GetValue()*1000;
    }
    Slider = NULL;
    Slider = (wxSlider*)FindWindow(ID_SLIDER_WIN_HORIZ);
    if (Slider != NULL)
    {
    	SettingsData.Width = Slider->GetValue();
    }
    Slider = NULL;
    Slider = (wxSlider*)FindWindow(ID_SLIDER_WIN_VERT);
    if (Slider != NULL)
    {
    	SettingsData.Height = Slider->GetValue();
    }

    wxFontPickerCtrl* FontPicker = (wxFontPickerCtrl*)FindWindow(ID_TERM_FONTPICKER);
    if (FontPicker != NULL)
    {
    	wxFont font;
    	font = FontPicker->GetSelectedFont();
    	SettingsData.TermFont = font.GetNativeFontInfoUserDesc();
    }
    FontPicker = NULL;
    FontPicker = (wxFontPickerCtrl*)FindWindow(ID_TRANSLATION_FONTPICKER);
    if (FontPicker != NULL)
    {
    	wxFont font;
    	font = FontPicker->GetSelectedFont();
    	SettingsData.TranslationFont = font.GetNativeFontInfoUserDesc();
    }

    wxColourPickerCtrl* ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_TERM_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	SettingsData.TermColor = ColorPicker->GetColour();
    }
    ColorPicker = NULL;
    ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_TRANSLATION_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	SettingsData.TranslationColor = ColorPicker->GetColour();
    }
    ColorPicker = NULL;
    ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_BACK_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	SettingsData.BackColor = ColorPicker->GetColour();
    }
    ColorPicker = NULL;
    ColorPicker = (wxColourPickerCtrl*)FindWindow(ID_BORDER_COLOURPICKER);
    if (ColorPicker != NULL)
    {
    	SettingsData.BorderColor = ColorPicker->GetColour();
    }

    return true;
}

void SettingsDialogClass::OnApplyButton(wxCommandEvent& event)
{
	TransferDataFromWindow();
    Settings = SettingsData;
	if ( MainWindow != NULL )
	{
		MainWindow->ApplyNewSettings();
	}
}

SettingsClass SettingsDialogClass::GetSettingsData() const
{
    return SettingsData;
}
