#ifndef SETTINGSDIALOG_H_
#define SETTINGSDIALOG_H_

#include <wx/wx.h>
#include <wx/display.h>
#include <wx/filepicker.h>
#include <wx/fontpicker.h>
#include <wx/clrpicker.h>
#include "settings.h"

enum
{
	ID_RADIOBUTTON_0 = 10000, ID_RADIOBUTTON_1 = 10001, ID_RADIOBUTTON_2 = 10002, ID_RADIOBUTTON_3 = 10003,
	ID_RADIOBUTTON_4 = 10004, ID_RADIOBUTTON_5 = 10005, ID_RADIOBUTTON_6 = 10006,
    ID_SETTINGS_DIALOG = 10007,
	ID_FILEPICKER = 10008,
	ID_TEXT = 10009,
    ID_SLIDER_TIMER_INTERVAL = 10010,
    ID_SLIDER_WIN_HORIZ = 10011,
    ID_SLIDER_WIN_VERT = 10012,
    ID_TERM_FONTPICKER = 10013,
    ID_TRANSLATION_FONTPICKER = 10014,
    ID_TERM_COLOURPICKER = 10015,
    ID_TRANSLATION_COLOURPICKER = 10016,
    ID_BACK_COLOURPICKER = 10017,
    ID_BORDER_COLOURPICKER = 10018
};

class SettingsDialogClass: public wxDialog
{
    DECLARE_CLASS( SettingsDialogClass )
    DECLARE_EVENT_TABLE()

public:
    SettingsDialogClass(const SettingsClass &Data, wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& caption = wxT("Settings"),
                        const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize,
                        long style = wxCAPTION|wxRESIZE_BORDER|wxDEFAULT_DIALOG_STYLE);
    void CreateControls();
    bool TransferDataToWindow();
    bool TransferDataFromWindow();
    void OnApplyButton(wxCommandEvent& event);
    SettingsClass GetSettingsData() const;

private:
    SettingsClass SettingsData;
};

#endif /* SETTINGSDIALOG_H_ */
