#include <wx/utils.h>
#include <wx/strconv.h>
#include "et.h"
#include "mainwindow.h"
#include "settings.h"

#include "et16x16.xpm"
const wxString szPublisherName = wxT("Winchester");
const wxString szWinName = wxT("English Teacher v2.0");
const wxString szCopyright = wxT("\n\nCopyright (c) 2011 by Oleg Lypkan");
wxTextFile file;

bool etApp::OnInit()
{
	Mutex = NULL;
    Mutex = new wxSingleInstanceChecker(szWinName+wxT(" - ")+wxGetUserId());
    if (Mutex == NULL) return false;
    if (Mutex->IsAnotherRunning())
    {
    	delete Mutex;
    	Mutex = NULL;
        return false;
    }
    // read settings
    Settings.ReadSettings();

    // read dictionary file
    if (!ReadDictionaryFile())
    {
    	delete Mutex;
    	Mutex = NULL;
		return false;
    }

    MainWindow = new etMainWindow(szWinName);
    MainWindow->SetSize(Settings.PosX, Settings.PosY, Settings.Width, Settings.Height);
    MainWindow->SetIcon(wxIcon(et16x16_xpm));
    MainWindow->Show(true);

    return true;
}

int etApp::OnExit()
{
	if (file.IsOpened())
	{
        file.Close();
	}
    if (Mutex != NULL) delete Mutex;
    return 0;
}

// Create object of etApp
IMPLEMENT_APP(etApp)

bool ReadDictionaryFile()
{
	wxCSConv Conv(wxFONTENCODING_CP1251);
	if (file.IsOpened())
	{
        file.Close();
	}
	if (!file.Open(Settings.FileName, Conv))
	{
        // file is not opened
		wxMessageBox(wxT("Cannot load dictionary file specified in configuration file.\nPlease specify existing non-empty dictionary file"), szWinName, wxOK);
        return false;
	}
	if (file.GetLineCount() == 0)
	{
        // file is empty
		wxMessageBox(wxT("Dictionary file specified in configuration file is empty.\nPlease specify existing non-empty dictionary file"), szWinName, wxOK);
        return false;
	}
	return true;
}
