#include <wx/dcbuffer.h>
#include <wx/brush.h>
#include <wx/apptrait.h>
#include "mainwindow.h"
#include "settings.h"
#include "SettingsDialog.h"
#include "et.h"

#include "et20x20.xpm"
#include "et22x22.xpm"
etMainWindow *MainWindow = NULL;

// Events table for etMainWindow
BEGIN_EVENT_TABLE(etMainWindow, wxFrame)
    EVT_ERASE_BACKGROUND(etMainWindow::OnErase)
    EVT_PAINT(etMainWindow::OnPaint)
    EVT_CLOSE(etMainWindow::OnClose)
    EVT_CONTEXT_MENU(etMainWindow::OnContextMenu)
    EVT_MENU(ID_SETTINGS, etMainWindow::OnProcessMenuCommand)
    EVT_MENU(ID_ABOUT, etMainWindow::OnProcessMenuCommand)
    EVT_MENU(ID_START_STOP_TIMER, etMainWindow::OnProcessMenuCommand)
    EVT_MENU(ID_SHOW_HIDE, etMainWindow::OnProcessMenuCommand)
    EVT_MENU(ID_CLOSE, etMainWindow::OnProcessMenuCommand)
    EVT_MOTION(etMainWindow::OnMouseMove)
    EVT_LEFT_DOWN(etMainWindow::OnMouseLeftDown)
    EVT_LEFT_UP(etMainWindow::OnMouseLeftUp)
    EVT_LEFT_DCLICK(etMainWindow::OnMouseDoubleClick)
    EVT_MOUSE_CAPTURE_LOST(etMainWindow::OnMouseCaptureLost)
    EVT_TIMER(TIMER_ID, etMainWindow::OnTimer)
END_EVENT_TABLE()

void etMainWindow::Paint()
{
    wxBufferedPaintDC dc(this);
    wxRect ClientRect = GetClientRect();

    // erase background
    dc.SetPen(wxPen(Settings.BorderColor));
    dc.SetBrush(wxBrush(Settings.BackColor));
    dc.DrawRectangle(ClientRect);

	wxFont font;
	ClientRect.Deflate(wxCoord(1), wxCoord(1));
	dc.SetBackgroundMode(wxTRANSPARENT);

	switch (ShowParam)
	{
	    case TERM_TRANSL:
	    case TERM:
			font.SetNativeFontInfoUserDesc(Settings.TermFont);
			dc.SetFont(font);
			dc.SetTextForeground(Settings.TermColor);
			dc.DrawLabel(term+((ShowParam==TERM_TRANSL)?wxT("\n"):wxT("")), wxNullBitmap, ClientRect, wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL);
			if (ShowParam != TERM_TRANSL) break;
	    case TRANSL:
			font.SetNativeFontInfoUserDesc(Settings.TranslationFont);
			dc.SetFont(font);
			dc.SetTextForeground(Settings.TranslationColor);
			dc.DrawLabel(((ShowParam==TERM_TRANSL)?wxT("\n"):wxT(""))+translation, wxNullBitmap, ClientRect, wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL);
	    	break;
	}

    // cleaning
    dc.SetPen(wxNullPen);
    dc.SetBrush(wxNullBrush);
    dc.SetFont(wxNullFont);
}

void etMainWindow::SetParameters()
{
	if ((Settings.ShowType == 0) || (Settings.ShowType == 1) || (Settings.ShowType == 2))
	{
		// this is needed to switch correctly from ShowType = [3,4,5,6] to ShowType = [0,1,2] at the moment when FirstTime = false
		FirstTime = true;
	}

	if (FirstTime) GetWord();

	switch (Settings.ShowType)
	{
		case 0:
			ShowParam = TERM_TRANSL;
			break;
		case 1:
			ShowParam = TERM;
			break;
		case 2:
			ShowParam = TRANSL;
			break;
		case 3:
			if (FirstTime) ShowParam = TERM;
			else ShowParam = TRANSL;
			break;
		case 4:
			if (FirstTime) ShowParam = TERM;
			else ShowParam = TERM_TRANSL;
			break;
		case 5:
			if (FirstTime) ShowParam = TRANSL;
			else ShowParam = TERM;
			break;
		case 6:
			if (FirstTime) ShowParam = TRANSL;
			else ShowParam = TERM_TRANSL;
			break;
	}
	if ((Settings.ShowType != 0) && (Settings.ShowType != 1) && (Settings.ShowType != 2))
	{
	    FirstTime = !FirstTime;
	}
}

void etMainWindow::OnTimer(wxTimerEvent& event)
{
	SetParameters();
    Refresh();
}

void etMainWindow::OnPaint(wxPaintEvent& event)
{
    Paint();
}

void etMainWindow::OnErase(wxEraseEvent& event)
{
// Empty implementation to prevent flicker,
// background will be erased in OnPaint
}

void etMainWindow::OnClose(wxCloseEvent& event)
{
	wxRect WindowRect = GetScreenRect();
    Settings.PosX = WindowRect.x;
    Settings.PosY = WindowRect.y;
    Settings.Width = WindowRect.width;
    Settings.Height = WindowRect.height;
	Settings.WriteSettings();
    Destroy();
}

void etMainWindow::OnMouseMove(wxMouseEvent& event)
{
    if (event.Dragging() && event.LeftIsDown())
    {
        wxPoint pt = ClientToScreen(event.GetPosition());
        int x = pt.x - m_delta.x;
        int y = pt.y - m_delta.y;
        Move(x, y);
    }
}

void etMainWindow::OnMouseLeftDown(wxMouseEvent& event)
{
    CaptureMouse();
    wxPoint pt = ClientToScreen(event.GetPosition());
    wxPoint origin = GetPosition();
    int dx = pt.x - origin.x;
    int dy = pt.y - origin.y;
    m_delta = wxPoint(dx, dy);
}

void etMainWindow::OnMouseLeftUp(wxMouseEvent& WXUNUSED(event))
{
    if (HasCapture())
    {
        ReleaseMouse();
    }
}

void etMainWindow::OnMouseDoubleClick(wxMouseEvent& WXUNUSED(event))
{
	StartStopTimer();
}

void etMainWindow::OnMouseCaptureLost(wxMouseCaptureLostEvent& event)
{

}

void etMainWindow::StartStopTimer()
{
	if (m_timer.IsRunning())
	{
	    m_timer.Stop();
	}
	else
	{
	    m_timer.Start(Settings.TimerInterval);
	}
}

void etMainWindow::ApplyNewSettings()
{
    if (Settings.FileName != file.GetName())
    {
        ReadDictionaryFile();
        srand(time(NULL));
        FirstTime = true;
        SetParameters();
    }
	wxRect WindowRect = GetScreenRect();
    if ((Settings.Width != WindowRect.width) || (Settings.Height != WindowRect.height))
    {
        SetSize(Settings.Width, Settings.Height);
        if (IsShownOnScreen())
        {
        	Show(false);
            Show(true);
        }
    }
    Refresh();
    if (m_timer.GetInterval() != Settings.TimerInterval)
    {
    	m_timer.Start(Settings.TimerInterval);
    }
}

void etMainWindow::OnProcessMenuCommand(wxCommandEvent& event)
{
    switch (event.GetId())
    {
        case ID_SETTINGS:
            {
        	    SettingsCalled = true;
        	    SettingsDialogClass SettingsDialog(Settings, this, ID_SETTINGS_DIALOG, szWinName+wxT(" - Settings"));
        	    if (SettingsDialog.ShowModal() == wxID_OK)
        	    {
                    Settings = SettingsDialog.GetSettingsData();
                    ApplyNewSettings();
        	    }
        	    SettingsCalled = false;
            }
        	break;
        case ID_ABOUT:
            AboutCalled = true;
        	wxMessageBox(szWinName+szCopyright,wxT("About"), wxOK, this);
        	AboutCalled = false;
        	break;
        case ID_START_STOP_TIMER:
        	StartStopTimer();
        	break;
        case ID_SHOW_HIDE:
        	Show(!IsShownOnScreen());
        	break;
        case ID_CLOSE:
            Close();
            break;
    }
}

void etMainWindow::FillContextMenu(wxMenu& ContextMenu)
{
    ContextMenu.Append(ID_SETTINGS, wxT("&Settings"));
    ContextMenu.Enable(ID_SETTINGS, !SettingsCalled);
    ContextMenu.Append(ID_ABOUT, wxT("&About"));
    ContextMenu.Enable(ID_ABOUT, !AboutCalled);
    ContextMenu.Append(wxID_SEPARATOR);
    ContextMenu.Append(ID_START_STOP_TIMER, (m_timer.IsRunning()?wxT("S&top"):wxT("S&tart")));
    if (m_taskBarIcon->IsIconInstalled())
    {
    	ContextMenu.Append(ID_SHOW_HIDE, (MainWindow->IsShownOnScreen()?wxT("&Hide"):wxT("S&how")));
    }
    ContextMenu.Append(wxID_SEPARATOR);
    ContextMenu.Append(ID_CLOSE, wxT("&Close"));
    ContextMenu.Enable(ID_CLOSE, !(AboutCalled || SettingsCalled));
}

void etMainWindow::OnContextMenu(wxContextMenuEvent& event)
{
    wxMenu ContextMenu;
    FillContextMenu(ContextMenu);

    wxPoint MenuPosition = event.GetPosition();
    if (MenuPosition == wxDefaultPosition)
    {
        MenuPosition = GetScreenPosition();
    }
    ScreenToClient(&(MenuPosition.x), &(MenuPosition.y));
    PopupMenu(&ContextMenu, MenuPosition);
}

void etMainWindow::GetWord()
{
    size_t lines = file.GetLineCount();
    size_t r = rand();
    r = r % lines;
	wxString line = file.GetLine(r);
	if (line.IsEmpty() || (line.GetChar(0)==wxChar('#')))
	{
		line = file.GetLine(lines-1);
	}

	size_t f = line.Find(wxChar('\t'));
	term = wxT("");
	term = line.Left(f);
    line.Remove(0,f+1);
    translation = wxT("");
    translation = line.Left(line.Find(wxChar('\t')));
}

etMainWindow::etMainWindow(const wxString& title)
             : wxFrame(NULL, wxID_ANY, title, wxDefaultPosition, wxDefaultSize,
               wxBORDER_NONE | wxFRAME_TOOL_WINDOW | wxSTAY_ON_TOP | wxFULL_REPAINT_ON_RESIZE)
{
	SetBackgroundStyle(wxBG_STYLE_CUSTOM);

    srand(time(NULL));
    FirstTime = true;
    AboutCalled = false;
    SettingsCalled = false;
    SetParameters();

	m_timer.SetOwner(this, TIMER_ID);
	m_timer.Start(Settings.TimerInterval);

	m_taskBarIcon = new MyTaskBarIcon();
	if (m_taskBarIcon->IsOk())
	{
		wxString DE = wxGetApp().GetTraits()->GetDesktopEnvironment();
		if (DE == wxT("KDE"))
		{
	        m_taskBarIcon->SetIcon(wxIcon(et22x22_xpm), szWinName);
		}
		else
		{
			m_taskBarIcon->SetIcon(wxIcon(et20x20_xpm), szWinName);
		}
	}
}
