#ifndef MAINWINDOW_H_
#define MAINWINDOW_H_

#include <wx/wx.h>
#include "systray.h"

enum ContextMenuItems { ID_SETTINGS = 10001, ID_ABOUT, ID_START_STOP_TIMER, ID_SHOW_HIDE, ID_CLOSE };
enum ShowParameters { TERM_TRANSL = 0, TERM = 1, TRANSL = 2 };
const int TIMER_ID = 1;

class etMainWindow : public wxFrame
{
public:
    etMainWindow(const wxString& title);
    ~etMainWindow() {delete m_taskBarIcon;}

    void Paint();
    void OnErase(wxEraseEvent& event);
    void OnPaint(wxPaintEvent& event);
    void OnClose(wxCloseEvent& event);
    void FillContextMenu(wxMenu& ContextMenu);
    void OnContextMenu(wxContextMenuEvent& event);
    void OnProcessMenuCommand(wxCommandEvent& event);
    void ApplyNewSettings();
    void OnTimer(wxTimerEvent& event);
    void GetWord();
    void SetParameters();
    void StartStopTimer();

protected:
    void OnMouseMove(wxMouseEvent& event);
    void OnMouseLeftDown(wxMouseEvent& event);
    void OnMouseLeftUp(wxMouseEvent& WXUNUSED(event));
    void OnMouseDoubleClick(wxMouseEvent& WXUNUSED(event));
    void OnMouseCaptureLost(wxMouseCaptureLostEvent& WXUNUSED(event));

    wxPoint m_delta;
    wxTimer m_timer;
	wxString term;
	wxString translation;
	ShowParameters ShowParam;
	bool FirstTime;
	bool AboutCalled;
	bool SettingsCalled;
    MyTaskBarIcon *m_taskBarIcon;

private:
    DECLARE_EVENT_TABLE()
};

extern etMainWindow *MainWindow;

#endif /* MAINWINDOW_H_ */
