#include <wx/fileconf.h>
#include <wx/display.h>
#include "settings.h"
#include "et.h"

SettingsClass Settings;

SettingsClass::SettingsClass()
{
	FileName = wxT("default.dat");
	TermFont = wxT("Arial bold italic 14");
	TranslationFont = wxT("Arial bold 12");
    TermColor.Set(wxString(wxT("#0000FF")));
    TranslationColor.Set(wxString(wxT("#FF0000")));
    BackColor.Set(wxString(wxT("#FFFF00")));
    BorderColor.Set(wxString(wxT("#000000")));
    PosX = -1;
    PosY = -1;
    Width = 250;
    Height = 75;
    TimerInterval = TimerIntervalMin * 2;
    ShowType = 0;
}

void SettingsClass::ReadSettings()
{
    wxFileConfig config(szWinName, szPublisherName);

    wxString StrValue;
    config.Read(wxT("General/FileName"), &StrValue, Settings.FileName);
    wxTextFile file(StrValue);
    if (file.Exists()) Settings.FileName = StrValue;

    long LongValue = 0;
    config.Read(wxT("General/ShowType"), &LongValue, Settings.ShowType);
    if ((LongValue >= 0) && (LongValue <= 6)) Settings.ShowType = LongValue;

    LongValue = 0;
    config.Read(wxT("General/TimerInterval"), &LongValue, Settings.TimerInterval);
    // valid Settings.TimerInterval range is 1 sec...30 sec
    if ((LongValue >= TimerIntervalMin) && (LongValue <= TimerIntervalMax)) Settings.TimerInterval = LongValue;

    StrValue = wxT("");
    config.Read(wxT("Fonts/TermFont"), &StrValue, Settings.TermFont);
    if (!StrValue.IsEmpty()) Settings.TermFont = StrValue;
	wxFont font;
	font.SetNativeFontInfoUserDesc(Settings.TermFont);
	Settings.TermFont = font.GetNativeFontInfoUserDesc();

    StrValue = wxT("");
    config.Read(wxT("Fonts/TranslationFont"), &StrValue, Settings.TranslationFont);
    if (!StrValue.IsEmpty()) Settings.TranslationFont = StrValue;
	font.SetNativeFontInfoUserDesc(Settings.TranslationFont);
	Settings.TranslationFont = font.GetNativeFontInfoUserDesc();

    StrValue = wxT("");
    config.Read(wxT("Colors/TermColor"), &StrValue, Settings.TermColor.GetAsString(wxC2S_HTML_SYNTAX));
    if (!StrValue.IsEmpty()) Settings.TermColor.Set(StrValue);

    StrValue = wxT("");
    config.Read(wxT("Colors/TranslationColor"), &StrValue, Settings.TranslationColor.GetAsString(wxC2S_HTML_SYNTAX));
    if (!StrValue.IsEmpty()) Settings.TranslationColor.Set(StrValue);

    StrValue = wxT("");
    config.Read(wxT("Colors/BackColor"), &StrValue, Settings.BackColor.GetAsString(wxC2S_HTML_SYNTAX));
    if (!StrValue.IsEmpty()) Settings.BackColor.Set(StrValue);

    StrValue = wxT("");
    config.Read(wxT("Colors/BorderColor"), &StrValue, Settings.BorderColor.GetAsString(wxC2S_HTML_SYNTAX));
    if (!StrValue.IsEmpty()) Settings.BorderColor.Set(StrValue);

    wxDisplay Display;
    wxRect DisplayRect = Display.GetGeometry();
    int DisplayWidth = DisplayRect.width;
    int DisplayHeight = DisplayRect.height;

    LongValue = 0;
    config.Read(wxT("Window/Width"), &LongValue, Settings.Width);
    if ((LongValue >= WinMinWidth) && (LongValue <= DisplayWidth)) Settings.Width = LongValue;

    LongValue = 0;
    config.Read(wxT("Window/Height"), &LongValue, Settings.Height);
    if ((LongValue >= WinMinHeight) && (LongValue <= DisplayHeight)) Settings.Height = LongValue;

    LongValue = 0;
    config.Read(wxT("Window/PosX"), &LongValue, Settings.PosX);
    if ((LongValue >= 0) && (LongValue <= (DisplayWidth-Settings.Width)))
    {
    	Settings.PosX = LongValue;
    }
    else
    {
    	Settings.PosX = (DisplayWidth-Settings.Width)/2;
    }

    LongValue = 0;
    config.Read(wxT("Window/PosY"), &LongValue, Settings.PosY);
    if ((LongValue >= 0) && (LongValue <= (DisplayHeight-Settings.Height)))
    {
    	Settings.PosY = LongValue;
    }
    else
    {
    	Settings.PosY = (DisplayHeight-Settings.Height)/2;
    }
}

void SettingsClass::WriteSettings()
{
    wxFileConfig config(szWinName, szPublisherName);

    config.Write(wxT("General/FileName"), Settings.FileName);
    config.Write(wxT("General/ShowType"), Settings.ShowType);
    config.Write(wxT("General/TimerInterval"), Settings.TimerInterval);

    config.Write(wxT("Fonts/TermFont"), Settings.TermFont);
    config.Write(wxT("Fonts/TranslationFont"), Settings.TranslationFont);

    config.Write(wxT("Colors/TermColor"), Settings.TermColor.GetAsString(wxC2S_HTML_SYNTAX));
    config.Write(wxT("Colors/TranslationColor"), Settings.TranslationColor.GetAsString(wxC2S_HTML_SYNTAX));
    config.Write(wxT("Colors/BackColor"), Settings.BackColor.GetAsString(wxC2S_HTML_SYNTAX));
    config.Write(wxT("Colors/BorderColor"), Settings.BorderColor.GetAsString(wxC2S_HTML_SYNTAX));

    config.Write(wxT("Window/PosX"), Settings.PosX);
    config.Write(wxT("Window/PosY"), Settings.PosY);
    config.Write(wxT("Window/Width"), Settings.Width);
    config.Write(wxT("Window/Height"), Settings.Height);
}
