#ifndef SETTINGS_H_
#define SETTINGS_H_

#include <wx/wx.h>

enum {TimerIntervalMin = 1000, TimerIntervalMax = 30000};
enum {WinMinWidth = 50, WinMinHeight = 25};

class SettingsClass
{
public:
	wxString FileName;
	wxString TermFont;
	wxString TranslationFont;
	wxColour TermColor;
	wxColour TranslationColor;
	wxColour BackColor;
	wxColour BorderColor;
	int PosX, PosY;
	int Width, Height;
	int TimerInterval;
	int ShowType;
	SettingsClass();
	void ReadSettings();  // reads settings from config file, validates them and assigns to corresponding class members
	void WriteSettings(); // saves values from corresponding class members to config file
};

extern SettingsClass Settings;

#endif /* SETTINGS_H_ */
