#include "systray.h"
#include "mainwindow.h"

BEGIN_EVENT_TABLE(MyTaskBarIcon, wxTaskBarIcon)
    EVT_MENU(ID_SETTINGS, MyTaskBarIcon::OnProcessMenuCommand)
    EVT_MENU(ID_ABOUT, MyTaskBarIcon::OnProcessMenuCommand)
    EVT_MENU(ID_START_STOP_TIMER, MyTaskBarIcon::OnProcessMenuCommand)
    EVT_MENU(ID_SHOW_HIDE, MyTaskBarIcon::OnProcessMenuCommand)
    EVT_MENU(ID_CLOSE,MyTaskBarIcon::OnProcessMenuCommand)
    EVT_TASKBAR_LEFT_DOWN(MyTaskBarIcon::OnLeftButtonClick)
END_EVENT_TABLE()

void MyTaskBarIcon::OnProcessMenuCommand(wxCommandEvent& event)
{
    if (MainWindow != NULL )
    {
        MainWindow->OnProcessMenuCommand(event);
    }
}

void MyTaskBarIcon::OnLeftButtonClick(wxTaskBarIconEvent& )
{
	if (MainWindow != NULL )
	{
		MainWindow->Show(!(MainWindow->IsShownOnScreen()));
	}
}

wxMenu *MyTaskBarIcon::CreatePopupMenu()
{
    wxMenu *menu = new wxMenu;
    if (MainWindow != NULL )
    {
        MainWindow->FillContextMenu(*menu);
    }
    return menu;
}
