<?php

// "@(#)$RCSfile: functions.php,v $$Revision: 1.18 $$Date: 2006/07/13 22:23:53 $";
//
//  Author: Oleg Lypkan
//  E-mail: www.winchester@gmail.com
//  Homepage: http://winchester.dp.ua
//  Copyright 2006. All rights reserved
//  This software is free. I grant you a non-exclusive license to use it
//

      require "config.php";
      require "layout.php";

      function IsLanguageEnglish()
      {
          if (empty($_GET["lang"]))
          {
              return false;
          }
          if (strcasecmp($_GET["lang"],"eng") != 0) // language is not English
          {
              return false;
          }
          else
          {
              return true;
          }
      }

      function add_protocol(&$string, &$protocol)
      {
          $protocol = "http://";
          if ((stristr($string,"://") === false) && (stristr($string,"mailto:") === false))
          {
              if (stristr($string,"ftp."))
              {
                  $protocol = "ftp://";
              }
              elseif (stristr($string,"@"))
              {
                  $protocol = "mailto:";
              }
              $string = sprintf("%s%s",$protocol,$string);
          }
      }
     
      function stop($message, $page_url)
      {
          global $ContinueMessageStyle;
          printf("<FONT class=\"$ContinueMessageStyle\">$message</FONT>", $page_url);
          echo "</TD>";
      }

      function stop_install($message,$action,$lang)
      {
          global $ErrorMessageStyle, $ContinueMessageStyle, $StopInstall;
          if (strcmp($action,"") != 0)
          {
              $action = "?action=".$action;
              if (strcasecmp($lang,"") != 0)
              {
                 $action = $action."&".$lang; // $lang = "?lang=eng"
              }
          }
          else
          {
              if (strcasecmp($lang,"") != 0)
              {
                 $action = "?".$lang;
              }
          }
          echo "<FONT class=\"$ErrorMessageStyle\">$message</FONT><BR>";
          printf("<FONT class=\"$ContinueMessageStyle\">$StopInstall</FONT>",$_SERVER["PHP_SELF"], $action);
      }

      function stop_login($message)
      {
          global $ErrorMessageStyle, $ContinueMessageStyle, $StopLogin;
          printf("<FONT class=\"$ErrorMessageStyle\">$message</FONT><BR>");
          printf("<FONT class=\"$ContinueMessageStyle\">$StopLogin</FONT>",$_SERVER["PHP_SELF"]);
      }

      function recognize_html(&$message_text)
      {
              global $LinkStyle;
              // recognizing some of HTML tags
              // recognizing [b],[/b] tags
              $message_text = str_replace("[b]","<b>",$message_text);
              $message_text = str_replace("[/b]","</b>",$message_text);
              $message_text = str_replace("[B]","<b>",$message_text);
              $message_text = str_replace("[/B]","</b>",$message_text);
              // recognizing [u],[/u] tags
              $message_text = str_replace("[u]","<u>",$message_text);
              $message_text = str_replace("[/u]","</u>",$message_text);
              $message_text = str_replace("[U]","<u>",$message_text);
              $message_text = str_replace("[/U]","</u>",$message_text);
              // recognizing [i],[/i] tags
              $message_text = str_replace("[i]","<i>",$message_text);
              $message_text = str_replace("[/i]","</i>",$message_text);
              $message_text = str_replace("[I]","<i>",$message_text);
              $message_text = str_replace("[/I]","</i>",$message_text);
              // recognizing [sub],[/sub] tags
              $message_text = str_replace("[sub]","<sub>",$message_text);
              $message_text = str_replace("[/sub]","</sub>",$message_text);
              $message_text = str_replace("[SUB]","<sub>",$message_text);
              $message_text = str_replace("[/SUB]","</sub>",$message_text);
              // recognizing [sup],[/sup] tags
              $message_text = str_replace("[sup]","<sup>",$message_text);
              $message_text = str_replace("[/sup]","</sup>",$message_text);
              $message_text = str_replace("[SUP]","<sup>",$message_text);
              $message_text = str_replace("[/SUP]","</sup>",$message_text);
              // recognizing [url],[/url] tags
              $open_url = "[url]";
              $close_url = "[/url]";
              $url_end = 0;
              do
              {
                  $url_begin = str_i_pos($message_text,$open_url,$url_end);
                  $url_end = str_i_pos($message_text,$close_url,$url_end+1);
                  if (($url_begin !== false) && ($url_end !== false)) // both tags exist in the message
                  {
                      $url_length = $url_end - $url_begin - strlen($open_url);
                      if ($url_length > 0) // there is at least 1 character between $open_url and $close_url tags
                      {
                          $url_text = substr($message_text,$url_begin+strlen($open_url),$url_length);
                      }
                      else
                      {
                          $url_text = " ";
                      }
                      if (str_i_pos($url_text,$open_url,0) === false)
                      {
                          $url_http = $url_text;
                          add_protocol($url_http, $protocol);
                          if (strcasecmp($url_text,$url_http))
                          {
                              $a_href = sprintf("<a href=\"%s",$protocol);
                          }
                          else
                          {
                              $a_href = "<a href=\"";
                          }
                          $url_text = sprintf("\" class=\"$LinkStyle\">%s</a>",$url_text);
                          $message_text = substr_replace($message_text,$url_text,$url_end,strlen($close_url));
                          $message_text = substr_replace($message_text,$a_href,$url_begin,strlen($open_url));
                      }
                      else 
                      { 
                          $url_end = $url_begin + 1;
                          continue;
                      }
                  }
                  else break;
              } while (true);
       }

       function str_i_pos($haystack, $needle, $offset)
       {
           $where_find = strtoupper($haystack);
           $what_find = strtoupper($needle);
           return strpos($where_find,$what_find,$offset);
       }

       // converts datetime from "YYYY-MM-DD HH:MM:SS" to "Month DD, YYYY HH:MM:SS" format
       // and corrects date/time taking into account client timezone from cookie
       function date_convert($old_date, &$new_date)
       {
           global $January, $February, $March, $April, $May, $June, $July, 
                  $August, $September, $October, $November, $December;
           $monthes = array("01"=>"$January","02"=>"$February","03"=>"$March","04"=>"$April",
                            "05"=>"$May","06"=>"$June","07"=>"$July","08"=>"$August","09"=>"$September",
                            "10"=>"$October","11"=>"$November","12"=>"$December");

           // correcting date/time taking into account client timezone from cookie
           if (!empty($_COOKIE["tz"]))
           {
                $ClientTZ = -$_COOKIE["tz"];
                $old_date = date("Y-m-d H:i:s",strtotime("$ClientTZ minutes",strtotime($old_date)));
                $GMT = "";
           }
           else
           {
                $GMT = " GMT";
           }
           
           if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})",$old_date,$regs))
           {
               if (IsLanguageEnglish())
               {
                   // converting datetime from "YYYY-MM-DD HH:MM:SS" to "Month DD, YYYY HH:MM:SS" (US) format
                   $new_date = sprintf("%s %s, %s, %s:%s:%s",$monthes["$regs[2]"],ltrim($regs[3],"0"),$regs[1],$regs[4],$regs[5],$regs[6]);
               }
               else
               {
                   // converting datetime from "YYYY-MM-DD HH:MM:SS" to "DD month YYYY HH:MM:SS" (RUS) format
                   $new_date = sprintf("%s %s %s, %s:%s:%s",ltrim($regs[3],"0"),$monthes["$regs[2]"],$regs[1],$regs[4],$regs[5],$regs[6]);
               }
           }
           else
               $new_date = $old_date;

           $new_date = $new_date.$GMT;
       }

       function print_message($row, $admin, $showbuttons)
       {
              // this function should be called inside a table
              global $From, $DateTimeStyle, $AdminNameStyle, $SenderNameStyle, $LocationStyle;
              global $AdminMessageStyle, $MessageTextStyle, $MessageBackgroundStyle, $AnswerBackgroundStyle;
              global $DateTimeAlign,$GBLangURL;
              global $Reply, $Delete;

              // printing date and time of the message
              echo "<TR>", "<TD align=\"$DateTimeAlign\">";
              date_convert($row["datetime"],$new_datetime);
              echo "<FONT class=\"$DateTimeStyle\">$new_datetime</FONT>";
              echo "</TD></TR>";

              // printing sender's name
              echo "<TR>", "<TD>";
              if (!strcasecmp($row["sender"],$admin["name"])) // Admin is sender
                  echo "<FONT class=\"$AdminNameStyle\">",$admin["name"],"</FONT>";
              else
                  echo "<FONT class=\"$SenderNameStyle\">",$row["sender"],"</FONT>";

              if (!empty($row["location"]))
                  printf("<FONT class=\"$LocationStyle\">$From {$row['location']}</FONT>");
       
              echo "<br>";

              if (!empty($row["mail"]))
                  printf("<a href=\"mailto:%s\"><img src=\"pictures/icon_email.gif\" alt=e-mail border=0></a>",$row["mail"]);
              else
                  if (!strcasecmp($row["sender"],$admin["name"]) && strcmp($admin["mail"],""))
                      printf("<a href=\"mailto:%s\"><img src=\"pictures/icon_email.gif\" alt=e-mail border=0></a>",$admin["mail"]);

              if (!empty($row["url"]))
                  printf("<a href=\"%s\"><img src=\"pictures/icon_url.gif\" alt=homepage border=0></a>",$row["url"]);
              else
                  if (!strcasecmp($row["sender"],$admin["name"]) && strcmp($admin["url"],""))
                      printf("<a href=\"%s\"><img src=\"pictures/icon_url.gif\" alt=homepage border=0></a>",$admin["url"]);

              if (!empty($row["icq"]))
                  printf("<a href=\"http://www.icq.com/whitepages/cmd.php?uin=%s&action=message\"><img src=\"pictures/icon_icq.gif\" alt=ICQ# border=0></a>",$row["icq"]);
              else
                  if (!strcasecmp($row["sender"],$admin["name"]) && strcmp($admin["icq"],""))
                      printf("<a href=\"http://www.icq.com/whitepages/cmd.php?uin=%s&action=message\"><img src=\"pictures/icon_icq.gif\" alt=ICQ# border=0></a>",$admin["icq"]);

              echo "</TD>", "</TR>";

              echo "<TR><TD class=\"$MessageBackgroundStyle\">";
              // printing message text
              if (!strcasecmp($row["sender"],$admin["name"])) // Admin is sender
                  echo "<FONT class=\"$AdminMessageStyle\">",$row["message"],"</FONT>";
              else
                  echo "<FONT class=\"$MessageTextStyle\">",$row["message"],"</FONT>";

              // show "delete" and "reply" buttons if Administrator is logged on
              if (isset($_SESSION["admin_logged"]) && $showbuttons==1)
              {
                  if (empty($GBLangURL))
                  {
                      printf("<BR><a href=\"admin.php?action=delete&id=%d&page=%d\"><img src=\"pictures/icon_delete.gif\" alt=\"$Delete\" border=\"0\"></a>",
                             $row["id"],$_GET["page"]);
                      printf("<a href=\"admin.php?action=reply&id=%d&page=%d\"><img src=\"pictures/icon_reply.gif\" alt=\"$Reply\" border=\"0\"></a>",
                             $row["id"],$_GET["page"]);
                  }
                  else
                  {
                      printf("<BR><a href=\"admin.php?action=delete&id=%d&page=%d&%s\"><img src=\"pictures/icon_delete.gif\" alt=\"$Delete\" border=\"0\"></a>",
                             $row["id"],$_GET["page"],$GBLangURL);
                      printf("<a href=\"admin.php?action=reply&id=%d&page=%d&%s\"><img src=\"pictures/icon_reply.gif\" alt=\"$Reply\" border=\"0\"></a>",
                             $row["id"],$_GET["page"],$GBLangURL);
                  }
              }
              echo "</TD></TR>";

              if (!empty($row["answer"]))
              {
                  // printing separator between the message and the answer
                  echo "<TR>", "<TD height=\"10\"></TD>", "</TR>";
        
                  // printing the answer
                  echo "<TR><TD>", "<TABLE cellSpacing=\"0\" cellPadding=\"0\" border=\"0\" width=\"100%\">", 
                       "<TR>", "<TD width=\"25\">&nbsp;</TD>", "<TD>";
                  
                  echo "<FONT class=\"$AdminNameStyle\">",$admin["name"],"</FONT>";

                  echo "<br>";

                  if (!empty($admin["mail"]))
                      printf("<a href=\"mailto:%s\"><img src=\"pictures/icon_email.gif\" alt=e-mail border=0></a>",$admin["mail"]);
             
                  if (!empty($admin["url"]))
                      printf("<a href=\"%s\"><img src=\"pictures/icon_url.gif\" alt=homepage border=0></a>",$admin["url"]);

                  if (!empty($admin["icq"]))
                      printf("<a href=\"http://www.icq.com/whitepages/cmd.php?uin=%s&action=message\"><img src=\"pictures/icon_icq.gif\" alt=ICQ# border=0></a>",$admin["icq"]);
                  
                  echo "</TD></TR>";
                  echo "<TR><TD>&nbsp;</TD><TD class=\"$AnswerBackgroundStyle\">";
                  echo "<FONT class=\"$AdminMessageStyle\">",$row["answer"],"</FONT>";
                  echo "</TD>", "</TR>", "</TABLE>", "</TD></TR>";
              }
       }

       // the function prepares message before viewing or sending
       function prepare_message(&$row, &$admin_info, $use_fullpath)
       {
              // converting special characters into HTML objects in order HTML code 
              // is not executed during viewing the page
              $row["sender"] = htmlspecialchars($row["sender"],ENT_QUOTES,"cp1251");
              $row["sender"] = str_replace("&amp;#","&#",$row["sender"]);
              $row["location"] = htmlspecialchars($row["location"],ENT_QUOTES,"cp1251");
              $row["location"] = str_replace("&amp;#","&#",$row["location"]);
              $row["mail"] = htmlspecialchars($row["mail"],ENT_QUOTES,"cp1251");
              $row["mail"] = str_replace("&amp;#","&#",$row["mail"]);
              $row["url"] = htmlspecialchars($row["url"],ENT_QUOTES,"cp1251");
              $row["url"] = str_replace("&amp;#","&#",$row["url"]);
              $row["icq"] = htmlspecialchars($row["icq"],ENT_QUOTES,"cp1251");
              $row["icq"] = str_replace("&amp;#","&#",$row["icq"]);
              $row["message"] = htmlspecialchars($row["message"],ENT_QUOTES,"cp1251");
              $row["message"] = str_replace("&amp;#","&#",$row["message"]);
              $row["message"] = nl2br($row["message"]);
              
              RecognizeSmiles($row["message"], $use_fullpath);

              if (isset($row["answer"]))
              {
                  $row["answer"] = htmlspecialchars($row["answer"],ENT_QUOTES,"cp1251");
                  $row["answer"] = str_replace("&amp;#","&#",$row["answer"]);
                  $row["answer"] = nl2br($row["answer"]);
                  RecognizeSmiles($row["answer"], false);
              }
              else
              {
                  $row["answer"] = "";
              }
              $admin_info["name"] = htmlspecialchars($admin_info["name"],ENT_QUOTES,"cp1251");
              $admin_info["name"] = str_replace("&amp;#","&#",$admin_info["name"]);
              $admin_info["mail"] = htmlspecialchars($admin_info["mail"],ENT_QUOTES,"cp1251");
              $admin_info["mail"] = str_replace("&amp;#","&#",$admin_info["mail"]);
              $admin_info["url"] = htmlspecialchars($admin_info["url"],ENT_QUOTES,"cp1251");
              $admin_info["url"] = str_replace("&amp;#","&#",$admin_info["url"]);
              $admin_info["icq"] = htmlspecialchars($admin_info["icq"],ENT_QUOTES,"cp1251");
              $admin_info["icq"] = str_replace("&amp;#","&#",$admin_info["icq"]);

              // recognizing some of HTML tags
              if (!empty($row["message"])) recognize_html($row["message"]);
              if (!empty($row["answer"])) recognize_html($row["answer"]);
       }

       function AddSlashesToSmiles(&$text)
       {
           $temp = "";
           for ($i = 0; $i < strlen($text); $i++)
           {
               if (!preg_match('/^[a-z0-9]*$/i', $text[$i]) && strpos($temp, $text[$i]) === FALSE)
               {
                    $temp = $temp.$text[$i];
               }
           }

           for ($i = 0; $i < strlen($temp); $i++)
           {
               $text = str_replace($temp[$i],"\\".$temp[$i],$text);
           }
       }

       function RecognizeSmiles(&$message, $use_fullpath)
       {
            global $recognize_smiles, $emoticons, $main_page;

            if ($recognize_smiles)
            {
                foreach($emoticons as $icon)
                {
                    if (IsLanguageEnglish())
                    {
                        $caption = empty($icon["caption_eng"]) ? "" : $icon["caption_eng"];
                    }
                    else
                    {
                        $caption = empty($icon["caption_rus"]) ? "" : $icon["caption_rus"];
                    }
                    $i = "1";
                    while (!empty($icon["text$i"]))
                    {
                        $fullpath = $use_fullpath ? $main_page."/guestbook/" : "";

                        $message = str_replace(" {$icon["text$i"]} "," <img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\"> ",$message);

                        AddSlashesToSmiles($icon["text$i"]);
                        // smile is at the beginning of the message
                        $message = preg_replace("/\A{$icon["text$i"]} /","<img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\"> ",$message);
                        // smile is at the beginning of the message and at the end of line
                        $message = preg_replace("/\A{$icon["text$i"]}\<br \/\>/","<img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\"><br />",$message);
                        // smile is at the end of the message
                        $message = preg_replace("/ {$icon["text$i"]}\z/"," <img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\">",$message);
                        // smile is at the end of the message and the beginning of the line
                        $message = preg_replace("/\n{$icon["text$i"]}\z/","<img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\">",$message);
                        // smile is at the beginning of the line
                        $message = preg_replace("/\n{$icon["text$i"]} /","<img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\"> ",$message);
                        // smile is at the end of the line
                        $message = preg_replace("/ {$icon["text$i"]}\<br \/\>/"," <img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\"><br />",$message);
                        // smile is at the beginning and at the end of the line
                        $message = preg_replace("/\n{$icon["text$i"]}\<br \/\>/","<img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\"><br />",$message);
                        // smile is at the beginning and at the end of the message
                        $message = preg_replace("/\A{$icon["text$i"]}\z/","<img src=\"{$fullpath}pictures/emoticons/{$icon['picture']}\" alt=\"$caption\">",$message);
                        $i++;
                    }
                }
            }
       }

       function PrintSmiles($FieldName)
       {
           global $emoticons, $GBLangURL, $smiles_field;

           if ($smiles_field && !empty($emoticons))
           {
               foreach($emoticons as $icon)
               {
                   echo "<a href=\"javascript:emoticon('{$icon['text1']}','$FieldName')\"><img src=\"pictures/emoticons/{$icon['picture']}\" border=\"0\" alt=\"",empty($GBLangURL) ? $icon['caption_rus'] : $icon['caption_eng'],"\"></a>\n";
               }
               return true;
           }
           else
           {
               return false;
           }
       }

       function read_admin_info(&$admin, $users, $link)
       {
           // reading information about administrator of guest book
           $sql = "SELECT * FROM $users WHERE type=1";
           $result = mysql_query($sql,$link);
           if ($result)
           {
               if (mysql_num_rows($result) == 1)
                   $admin = mysql_fetch_array($result);
           }
       }

       function redirect($url)
       {
           echo "<HTML><HEAD>\n";
           echo "<META HTTP-EQUIV='Refresh' CONTENT='0; URL=$url'>\n";
           echo "</HEAD></HTML>\n";
       }

       function IsInstallComplete()
       {
           global $link;
           global $dbName, $table, $users, $antispam_table;

           $tables = array();
           $sql = "SHOW TABLES FROM $dbName";
           $result = @mysql_query($sql,$link);
           if ($result)
           {
              while ($row = @mysql_fetch_array($result))
              {
                  $tables[] = $row[0];
              }
           }
           if (!in_array($table,$tables)) return false;
           if (!in_array($users,$tables)) return false;
           if (!in_array($antispam_table,$tables)) return false;
           return true;
       }

       function GetAntiSpamCode($sid)
       {
           global $antispam_table;

           $string = "";
           $code = mt_rand(100000,999999);

           // removing old code from database for current session
           $sql = "DELETE FROM $antispam_table WHERE sid='$sid'";
           @mysql_query($sql);
           
           // removing codes for sessions older than 1 hour
           $time = time()-3600;
           $sql = "DELETE FROM $antispam_table WHERE time<$time";
           @mysql_query($sql);
           
           // saving newly generated code to the database
           $time += 3600;
           $sql = "INSERT INTO $antispam_table VALUES ('$time', '$sid', '$code')";
           @mysql_query($sql);
           
           while($code / 10 != 0)
           {
               $string = ($code % 10) . " " . $string;
               $code = floor($code / 10);
           }
           return trim($string);
       }

?>
